#Difference finder for only 2 

#ff you want ONLY FULL MOTIFS, put "YES" here, please use all caps
FullMotifsOnly_questionmark<-"NO"
#If you want ONLY TRUNCATED MOTIFS, put "YES" here, please use all caps
TruncatedMotifsOnly_questionmark<-"NO"

FirstSubstrateSet<- read.csv("Substrates 1A TiO2 and FeNTA no duplicates.csv", stringsAsFactors=FALSE)
Firstsubbackfreq<- read.csv("SBF 1A TiO2 and FeNTA no duplicates.csv", header=FALSE, stringsAsFactors=FALSE)

SecondSubstrateSet<- read.csv("Substrates 1B TiO2 and FeNTA no duplicates.csv", stringsAsFactors=FALSE)
Secondsubbackfreq<- read.csv("SBF 1B TiO2 and FeNTA no duplicates.csv", header=FALSE, stringsAsFactors=FALSE)

First_unshared_motifs_table<-"Substrates 1A no duplicates no negatives.csv"
First_unshared_subbackfreq<-"SBF 1A no duplicates no negatives.csv"

Second_unshared_motifs_table<-"Substrates 1B no duplicates no negatives.csv"
Second_unshared_subbackfreq<-"SBF 1B no duplicates no negatives.csv"


LeftOfYLetters<-7
RightOfYLetters<-7

if (FullMotifsOnly_questionmark=="YES"){
  FirstMotifs=rep(NA,times=nrow(FirstSubstrateSet))
  FirstAccessionNumbers=rep(NA,times=nrow(FirstSubstrateSet))
  leftspaces<-c()
  rightspaces<-c()
  for (i in 1:nrow(FirstSubstrateSet)){
    FirstLetters<-FirstSubstrateSet[i,7:15]
    FirstLetters<-FirstLetters[FirstLetters !="XXXXX"]
    FirstLetters<-paste(FirstLetters, sep="", collapse="")
    
    
    YYYmotif <- unlist(strsplit(FirstLetters, split = ""))
    YYYposition <- match(x = "x", table = YYYmotif)
    #position itself tells me how much is to the left of that X by what it's number is.  x at position 4 tells me that there are
    #just 3 letters to the left of x
    
    YYYLettersToTheLeft <- YYYposition - 1
    #how many letters to the right SHOULD just be length(motif)-position-1 if it's 5 long and x is at 3 then Y is at 4 and there is
    #just 1 spot to the right of Y so LettersToTheRight<-1 because 5-3-1=1
    YYYLettersToTheRight <- length(YYYmotif) - YYYposition - 1
    #then sanity check, we're currently looking only at +/-4, but this spot allows for up to +/- 7 as well, just depends on what the
    #variable the user puts in is
    
    if (YYYLettersToTheLeft > 3 && YYYLettersToTheRight > 3) {
      motif<-YYYmotif
      #save that motif, which is the Y and +/- 4 amino acids, including truncation
      motif<-motif[!motif %in% "x"]
      motif<-paste(motif, sep="", collapse="")
      FirstLetters<-motif
      FirstMotifs[i]<-FirstLetters
      FirstAccessionNumbers[i]<-FirstSubstrateSet[i,3]
    }
    
  }
  # FirstMotifs <- FirstMotifs[!is.na(FirstMotifs)]
  # FirstMotifs<-matrix(FirstMotifs,ncol = 1)
  # 
  
  SecondMotifs=rep(NA,times=nrow(FirstSubstrateSet))
  SecondAccessionNumbers=rep(NA,times=nrow(FirstSubstrateSet))
  
  for (i in 1:nrow(SecondSubstrateSet)){
    SecondLetters<-SecondSubstrateSet[i,7:15]
    SecondLetters<-SecondLetters[SecondLetters !="XXXXX"]
    SecondLetters<-paste(SecondLetters, sep="", collapse="")
    
    
    YYYmotif <- unlist(strsplit(SecondLetters, split = ""))
    YYYposition <- match(x = "x", table = YYYmotif)
    #position itself tells me how much is to the left of that X by what it's number is.  x at position 4 tells me that there are
    #just 3 letters to the left of x
    
    YYYLettersToTheLeft <- YYYposition - 1
    #how many letters to the right SHOULD just be length(motif)-position-1 if it's 5 long and x is at 3 then Y is at 4 and there is
    #just 1 spot to the right of Y so LettersToTheRight<-1 because 5-3-1=1
    YYYLettersToTheRight <- length(YYYmotif) - YYYposition - 1
    #then sanity check, we're currently looking only at +/-4, but this spot allows for up to +/- 7 as well, just depends on what the
    #variable the user puts in is
    
    if (YYYLettersToTheLeft > 3 && YYYLettersToTheRight > 3) {
      motif<-YYYmotif
      #add blank spaces if the motif has less than 4 letters to the left/right
      motif<-c(leftspaces,YYYmotif,rightspaces)
      #save that motif, which is the Y and +/- 4 amino acids, including truncation
      motif<-motif[!motif %in% "x"]
      motif<-paste(motif, sep="", collapse="")
      SecondLetters<-motif
      SecondMotifs[i]<-SecondLetters
      SecondAccessionNumbers[i]<-SecondSubstrateSet[i,3]
    }
  }
  names(FirstMotifs)<-FirstAccessionNumbers
  names(SecondMotifs)<-SecondAccessionNumbers
  
  
#  ITDmotifs=rep(NA,times=nrow(FirstSubstrateSet))
#  ITDAccessionNumbers=rep(NA,times=nrow(FirstSubstrateSet))
  if(1==0){
    for (i in 1:nrow(ThirdSubstrateSet)){
      ITDletters<-ThirdSubstrateSet[i,7:15]
      ITDletters<-ITDletters[ITDletters !="XXXXX"]
      ITDletters<-paste(ITDletters, sep="", collapse="")
      YYYmotif <- unlist(strsplit(ITDletters, split = ""))
      YYYposition <- match(x = "x", table = YYYmotif)
      #position itself tells me how much is to the left of that X by what it's number is.  x at position 4 tells me that there are
      #just 3 letters to the left of x
      
      YYYLettersToTheLeft <- YYYposition - 1
      #how many letters to the right SHOULD just be length(motif)-position-1 if it's 5 long and x is at 3 then Y is at 4 and there is
      #just 1 spot to the right of Y so LettersToTheRight<-1 because 5-3-1=1
      YYYLettersToTheRight <- length(YYYmotif) - YYYposition - 1
      #then sanity check, we're currently looking only at +/-4, but this spot allows for up to +/- 7 as well, just depends on what the
      #variable the user puts in is
      
      if (YYYLettersToTheLeft > 3 && YYYLettersToTheRight > 3) {
        motif<-YYYmotif
        #add blank spaces if the motif has less than 4 letters to the left/right
        motif<-c(leftspaces,YYYmotif,rightspaces)
        #save that motif, which is the Y and +/- 4 amino acids, including truncation
        motif<-motif[!motif %in% "x"]
        motif<-paste(motif, sep="", collapse="")
        ITDletters<-motif
        ITDmotifs[i]<-ITDletters
        ITDAccessionNumbers[i]<-ThirdSubstrateSet[i,3]
        
      }
    }
  }  
  #names(ITDmotifs)<-ITDAccessionNumbers
  names(SecondMotifs)<-SecondAccessionNumbers
  names(FirstMotifs)<-FirstAccessionNumbers
}


##############################################3
#Truncated only
if (TruncatedMotifsOnly_questionmark=="YES"){
  FirstMotifs=matrix(,nrow = nrow(FirstSubstrateSet),ncol=1)
  FirstAccessionNumbers=matrix(,nrow = nrow(FirstSubstrateSet),ncol=1)
  
  for (i in 1:nrow(FirstSubstrateSet)){
    FirstLetters<-FirstSubstrateSet[i,7:15]
    FirstLetters<-FirstLetters[FirstLetters !="XXXXX"]
    FirstLetters<-paste(FirstLetters, sep="", collapse="")
    
    
    YYYmotif <- unlist(strsplit(FirstLetters, split = ""))
    YYYposition <- match(x = "x", table = YYYmotif)
    #position itself tells me how much is to the left of that X by what it's number is.  x at position 4 tells me that there are
    #just 3 letters to the left of x
    
    YYYLettersToTheLeft <- YYYposition - 1
    #how many letters to the right SHOULD just be length(motif)-position-1 if it's 5 long and x is at 3 then Y is at 4 and there is
    #just 1 spot to the right of Y so LettersToTheRight<-1 because 5-3-1=1
    YYYLettersToTheRight <- length(YYYmotif) - YYYposition - 1
    #then sanity check, we're currently looking only at +/-4, but this spot allows for up to +/- 7 as well, just depends on what the
    #variable the user puts in is
    
    if (YYYLettersToTheLeft < 4 | YYYLettersToTheRight < 4) {
      leftspaces<-rep(" ",times=(4-YYYLettersToTheLeft))
      rightspaces<-rep(" ",times=4-(YYYLettersToTheRight))
      #add blank spaces if the motif has less than 4 letters to the left/right
      motif<-c(leftspaces,YYYmotif,rightspaces)
      #save that motif, which is the Y and +/- 4 amino acids, including truncation
      motif<-motif[!motif %in% "x"]
      motif<-paste(motif, sep="", collapse="")
      FirstLetters<-motif
      FirstMotifs[i,1]<-FirstLetters
      FirstAccessionNumbers[i,1]<-FirstSubstrateSet[i,3]
    }
    
  }
  
  SecondMotifs=matrix(,nrow = nrow(SecondSubstrateSet),ncol=1)
  SecondAccessionNumbers<-matrix(,nrow = nrow(SecondSubstrateSet),ncol = 1)
  i=2
  for (i in 1:nrow(SecondSubstrateSet)){
    SecondLetters<-SecondSubstrateSet[i,7:15]
    SecondLetters<-SecondLetters[SecondLetters !="XXXXX"]
    SecondLetters<-paste(SecondLetters, sep="", collapse="")
    
    
    YYYmotif <- unlist(strsplit(SecondLetters, split = ""))
    YYYposition <- match(x = "x", table = YYYmotif)
    #position itself tells me how much is to the left of that X by what it's number is.  x at position 4 tells me that there are
    #just 3 letters to the left of x
    
    YYYLettersToTheLeft <- YYYposition - 1
    #how many letters to the right SHOULD just be length(motif)-position-1 if it's 5 long and x is at 3 then Y is at 4 and there is
    #just 1 spot to the right of Y so LettersToTheRight<-1 because 5-3-1=1
    YYYLettersToTheRight <- length(YYYmotif) - YYYposition - 1
    #then sanity check, we're currently looking only at +/-4, but this spot allows for up to +/- 7 as well, just depends on what the
    #variable the user puts in is
    
    if (YYYLettersToTheLeft < 4 | YYYLettersToTheRight < 4) {
      leftspaces<-rep(" ",times=(4-YYYLettersToTheLeft))
      rightspaces<-rep(" ",times=4-(YYYLettersToTheRight))
      #add blank spaces if the motif has less than 4 letters to the left/right
      motif<-c(leftspaces,YYYmotif,rightspaces)
      #save that motif, which is the Y and +/- 4 amino acids, including truncation
      motif<-motif[!motif %in% "x"]
      motif<-paste(motif, sep="", collapse="")
      SecondLetters<-motif
      SecondAccessionNumbers[i,1]<-SecondSubstrateSet[i,3]
      SecondMotifs[i,1]<-SecondLetters
    }
  }
  
#  ITDmotifs=matrix(,nrow = nrow(ThirdSubstrateSet),ncol=1)
#  ITDAccessionNumbers<-matrix(,nrow = nrow(ThirdSubstrateSet))
  if(1==0){
    for (i in 1:nrow(ThirdSubstrateSet)){
      ITDletters<-ThirdSubstrateSet[i,7:15]
      ITDletters<-ITDletters[ITDletters !="XXXXX"]
      ITDletters<-paste(ITDletters, sep="", collapse="")
      YYYmotif <- unlist(strsplit(ITDletters, split = ""))
      YYYposition <- match(x = "x", table = YYYmotif)
      #position itself tells me how much is to the left of that X by what it's number is.  x at position 4 tells me that there are
      #just 3 letters to the left of x
      
      YYYLettersToTheLeft <- YYYposition - 1
      #how many letters to the right SHOULD just be length(motif)-position-1 if it's 5 long and x is at 3 then Y is at 4 and there is
      #just 1 spot to the right of Y so LettersToTheRight<-1 because 5-3-1=1
      YYYLettersToTheRight <- length(YYYmotif) - YYYposition - 1
      #then sanity check, we're currently looking only at +/-4, but this spot allows for up to +/- 7 as well, just depends on what the
      #variable the user puts in is
      
      if (YYYLettersToTheLeft < 4 | YYYLettersToTheRight < 4) {
        leftspaces<-rep(" ",times=(4-YYYLettersToTheLeft))
        rightspaces<-rep(" ",times=4-(YYYLettersToTheRight))
        #add blank spaces if the motif has less than 4 letters to the left/right
        motif<-c(leftspaces,YYYmotif,rightspaces)
        #save that motif, which is the Y and +/- 4 amino acids, including truncation
        motif<-motif[!motif %in% "x"]
        motif<-paste(motif, sep="", collapse="")
        ITDletters<-motif
        ITDAccessionNumbers[i,1]<-ThirdSubstrateSet[i,3]
        ITDmotifs[i,1]<-ITDletters
      }
    }
  }
  names(FirstMotifs)<-FirstAccessionNumbers
  names(SecondMotifs)<-SecondAccessionNumbers
  #names(ITDmotifs)<-ITDAccessionNumbers
}

###############################################
#ALL motifs, full and truncated

if (FullMotifsOnly_questionmark!="YES"&&TruncatedMotifsOnly_questionmark!="YES"){
  #print("!")}
  FirstMotifs=matrix(,nrow = nrow(FirstSubstrateSet),ncol=1)
  FirstAccessionNumbers=matrix(,nrow = nrow(FirstSubstrateSet),ncol=1)
  
  for (i in 1:nrow(FirstSubstrateSet)){
    FirstLetters<-FirstSubstrateSet[i,7:15]
    FirstLetters<-FirstLetters[FirstLetters !="XXXXX"]
    FirstLetters<-paste(FirstLetters, sep="", collapse="")
    leftspaces<-c()
    rightspaces<-c()
    
    YYYmotif <- unlist(strsplit(FirstLetters, split = ""))
    YYYposition <- match(x = "x", table = YYYmotif)
    #position itself tells me how much is to the left of that X by what it's number is.  x at position 4 tells me that there are
    #just 3 letters to the left of x
    
    YYYLettersToTheLeft <- YYYposition - 1
    #how many letters to the right SHOULD just be length(motif)-position-1 if it's 5 long and x is at 3 then Y is at 4 and there is
    #just 1 spot to the right of Y so LettersToTheRight<-1 because 5-3-1=1
    YYYLettersToTheRight <- length(YYYmotif) - YYYposition - 1
    #then sanity check, we're currently looking only at +/-4, but this spot allows for up to +/- 7 as well, just depends on what the
    #variable the user puts in is
    
    
    if (YYYLettersToTheLeft < 4 | YYYLettersToTheRight < 4) {
      leftspaces<-rep(" ",times=(4-YYYLettersToTheLeft))
      rightspaces<-rep(" ",times=4-(YYYLettersToTheRight))
      #add blank spaces if the motif has less than 4 letters to the left/right
      motif<-c(leftspaces,YYYmotif,rightspaces)
      #save that motif, which is the Y and +/- 4 amino acids, including truncation
      motif<-motif[!motif %in% "x"]
      motif<-paste(motif, sep="", collapse="")
      FirstLetters<-motif
      FirstMotifs[i,1]<-FirstLetters
      FirstAccessionNumbers[i,1]<-FirstSubstrateSet[i,3]
    }
    
    if(YYYLettersToTheLeft>3 && YYYLettersToTheRight>3){
      motif<-YYYmotif
      #add blank spaces if the motif has less than 4 letters to the left/right
      motif<-c(leftspaces,YYYmotif,rightspaces)
      #save that motif, which is the Y and +/- 4 amino acids, including truncation
      motif<-motif[!motif %in% "x"]
      motif<-paste(motif, sep="", collapse="")
      FirstLetters<-motif
      FirstMotifs[i,1]<-FirstLetters
      FirstAccessionNumbers[i,1]<-FirstSubstrateSet[i,3]
      
      
    }
    
  }
  
  SecondMotifs=matrix(,nrow = nrow(SecondSubstrateSet),ncol=1)
  SecondAccessionNumbers<-matrix(,nrow = nrow(SecondSubstrateSet),ncol = 1)
  
  for (i in 1:nrow(SecondSubstrateSet)){
    SecondLetters<-SecondSubstrateSet[i,7:15]
    SecondLetters<-SecondLetters[SecondLetters !="XXXXX"]
    SecondLetters<-paste(SecondLetters, sep="", collapse="")
    leftspaces<-c()
    rightspaces<-c()
    
    YYYmotif <- unlist(strsplit(SecondLetters, split = ""))
    YYYposition <- match(x = "x", table = YYYmotif)
    #position itself tells me how much is to the left of that X by what it's number is.  x at position 4 tells me that there are
    #just 3 letters to the left of x
    
    YYYLettersToTheLeft <- YYYposition - 1
    #how many letters to the right SHOULD just be length(motif)-position-1 if it's 5 long and x is at 3 then Y is at 4 and there is
    #just 1 spot to the right of Y so LettersToTheRight<-1 because 5-3-1=1
    YYYLettersToTheRight <- length(YYYmotif) - YYYposition - 1
    #then sanity check, we're currently looking only at +/-4, but this spot allows for up to +/- 7 as well, just depends on what the
    #variable the user puts in is
    if (YYYLettersToTheLeft < 4 | YYYLettersToTheRight < 4) {
      leftspaces<-rep(" ",times=(4-YYYLettersToTheLeft))
      rightspaces<-rep(" ",times=4-(YYYLettersToTheRight))
      #add blank spaces if the motif has less than 4 letters to the left/right
      motif<-c(leftspaces,YYYmotif,rightspaces)
      #save that motif, which is the Y and +/- 4 amino acids, including truncation
      motif<-motif[!motif %in% "x"]
      motif<-paste(motif, sep="", collapse="")
      SecondLetters<-motif
      SecondMotifs[i,1]<-SecondLetters
      SecondAccessionNumbers[i,1]<-SecondSubstrateSet[i,3]
    }
    
    if(YYYLettersToTheLeft>3 && YYYLettersToTheRight>3){
      motif<-YYYmotif
      #add blank spaces if the motif has less than 4 letters to the left/right
      motif<-c(leftspaces,YYYmotif,rightspaces)
      #save that motif, which is the Y and +/- 4 amino acids, including truncation
      motif<-motif[!motif %in% "x"]
      motif<-paste(motif, sep="", collapse="")
      SecondLetters<-motif
      SecondMotifs[i,1]<-SecondLetters
      SecondAccessionNumbers[i,1]<-SecondSubstrateSet[i,3]
    }
  }
  
  
  #ITDmotifs=matrix(,nrow = nrow(ThirdSubstrateSet),ncol=1)
  #ITDAccessionNumbers<-matrix(,nrow = nrow(ThirdSubstrateSet))
  if(1==0){
  for (i in 1:nrow(ThirdSubstrateSet)){
    ITDletters<-ThirdSubstrateSet[i,7:15]
    ITDletters<-ITDletters[ITDletters !="XXXXX"]
    ITDletters<-paste(ITDletters, sep="", collapse="")
    YYYmotif <- unlist(strsplit(ITDletters, split = ""))
    leftspaces<-c()
    rightspaces<-c()
    YYYposition <- match(x = "x", table = YYYmotif)
    #position itself tells me how much is to the left of that X by what it's number is.  x at position 4 tells me that there are
    #just 3 letters to the left of x
    
    YYYLettersToTheLeft <- YYYposition - 1
    #how many letters to the right SHOULD just be length(motif)-position-1 if it's 5 long and x is at 3 then Y is at 4 and there is
    #just 1 spot to the right of Y so LettersToTheRight<-1 because 5-3-1=1
    YYYLettersToTheRight <- length(YYYmotif) - YYYposition - 1
    #then sanity check, we're currently looking only at +/-4, but this spot allows for up to +/- 7 as well, just depends on what the
    #variable the user puts in is
    if (YYYLettersToTheLeft < 4 | YYYLettersToTheRight < 4) {
      leftspaces<-rep(" ",times=(4-YYYLettersToTheLeft))
      rightspaces<-rep(" ",times=4-(YYYLettersToTheRight))
      #add blank spaces if the motif has less than 4 letters to the left/right
      motif<-c(leftspaces,YYYmotif,rightspaces)
      #save that motif, which is the Y and +/- 4 amino acids, including truncation
      motif<-motif[!motif %in% "x"]
      motif<-paste(motif, sep="", collapse="")
      ITDletters<-motif
      ITDmotifs[i,1]<-ITDletters
      ITDAccessionNumbers[i,1]<-FirstSubstrateSet[i,3]
    }
    
    if(YYYLettersToTheLeft>3 && YYYLettersToTheRight>3){
      motif<-YYYmotif
      #add blank spaces if the motif has less than 4 letters to the left/right
      motif<-c(leftspaces,YYYmotif,rightspaces)
      #save that motif, which is the Y and +/- 4 amino acids, including truncation
      motif<-motif[!motif %in% "x"]
      motif<-paste(motif, sep="", collapse="")
      ITDletters<-motif
      ITDmotifs[i,1]<-ITDletters
      ITDAccessionNumbers[i,1]<-FirstSubstrateSet[i,3]
    }
  }
  }
  names(FirstMotifs)<-FirstAccessionNumbers
  names(SecondMotifs)<-SecondAccessionNumbers
  #names(ITDmotifs)<-ITDAccessionNumbers
}


FirstMotifsFINAL<-FirstMotifs[!FirstMotifs %in% SecondMotifs]
#FirstMotifsFINAL<-FirstMotifsFINAL[!FirstMotifsFINAL %in% ITDmotifs]
FirstMotifsFINAL<-FirstMotifsFINAL[!duplicated(FirstMotifsFINAL)]


# ITDmotifsFINAL<-ITDmotifs[!ITDmotifs %in% SecondMotifs]
# ITDmotifsFINAL<-ITDmotifsFINAL[!ITDmotifsFINAL %in% FirstMotifs]
# ITDmotifsFINAL<-ITDmotifsFINAL[!duplicated(ITDmotifsFINAL)]


SecondMotifsFINAL<-SecondMotifs[!SecondMotifs %in% FirstMotifs]
#SecondMotifsFINAL<-SecondMotifsFINAL[!SecondMotifsFINAL %in% ITDmotifs]
SecondMotifsFINAL<-SecondMotifsFINAL[!duplicated(SecondMotifsFINAL)]


columnalheader<-c(rep(NA,36))
FirstFinalMatrix<-matrix(data =columnalheader,nrow = 1)

for (k in 1:length(FirstMotifsFINAL)) {
  AN<-00000
  #I don't remember why, but I felt it necessary to destroy the accession number multiple times to ensure it is
  #destroyed immediately after use
  for (m in 2:ncol(Firstsubbackfreq)) {
    AN <- as.character(Firstsubbackfreq[2, m])
    #print(AN)}
    if (grepl(pattern = AN,
              x = names(FirstMotifsFINAL[k]),
              fixed = TRUE) == TRUE) {
      outputmatrix <- as.character(Firstsubbackfreq[, m])
      outputmatrix <- matrix(outputmatrix, nrow = 1)
      #with that accession number, find a match in the subbackfreq file and save it here
      FirstFinalMatrix<-rbind(FirstFinalMatrix,outputmatrix)
      #      print(AN,outputmatrix)}
    }
  }
}
FirstFinalMatrix<-FirstFinalMatrix[!duplicated(FirstFinalMatrix),]

#columnalheader<-c(rep(NA,36))
#ITDFinalMatrix<-matrix(data =columnalheader,nrow = 1)

if(1==0){
  for (k in 1:length(ITDmotifsFINAL)) {
    AN<-00000
    #I don't remember why, but I felt it necessary to destroy the accession number multiple times to ensure it is
    #destroyed immediately after use
    for (m in 1:ncol(Thirdsubbackfreq)) {
      AN <- as.character(Thirdsubbackfreq[1, m])
      if (grepl(pattern = AN,
                x = names(ITDmotifsFINAL[k]),
                fixed = TRUE) == TRUE) {
        outputmatrix <- as.character(Thirdsubbackfreq[, m])
        outputmatrix <- matrix(outputmatrix, nrow = 1)
        #with that accession number, find a match in the subbackfreq file and save it here
        ITDFinalMatrix<-rbind(ITDFinalMatrix,outputmatrix)
      }
    }
  }
  ITDFinalMatrix<-ITDFinalMatrix[!duplicated(ITDFinalMatrix),]
}

columnalheader<-c(rep(NA,36))
SecondFinalMatrix<-matrix(data =columnalheader,nrow = 1)

for (k in 1:length(SecondMotifsFINAL)) {
  #I don't remember why, but I felt it necessary to destroy the accession number multiple times to ensure it is
  #destroyed immediately after use
  for (m in 1:ncol(Secondsubbackfreq)) {
    AN <- as.character(Secondsubbackfreq[1, m])
    if (grepl(pattern = AN,
              x = names(SecondMotifsFINAL[k]),
              fixed = TRUE) == TRUE) {
      outputmatrix <- as.character(Secondsubbackfreq[, m])
      outputmatrix <- matrix(outputmatrix, nrow = 1)
      #with that accession number, find a match in the subbackfreq file and save it here
      SecondFinalMatrix<-rbind(SecondFinalMatrix,outputmatrix)
    }
  }
}
SecondFinalMatrix<-SecondFinalMatrix[!duplicated(SecondFinalMatrix),]
FTLoutputmatrix<-matrix(data=c(FirstMotifsFINAL,names(FirstMotifsFINAL)),ncol = 2)


write.table(x=FTLoutputmatrix,
            file=First_unshared_motifs_table,
            quote=FALSE, sep=",",
            row.names=FALSE,col.names = FALSE, na="", append=TRUE)

columnalheader<-c(as.character(Firstsubbackfreq[1:36,1]))
columnalheader<-matrix(columnalheader,nrow = 1)
write.table(x=columnalheader,
            file=First_unshared_subbackfreq,
            quote=FALSE, sep=",",
            row.names=FALSE,col.names = FALSE, na="", append=TRUE)
FirstFinalMatrix<-FirstFinalMatrix[2:nrow(FirstFinalMatrix),]
write.table(x=FirstFinalMatrix,
            file=First_unshared_subbackfreq,
            quote=FALSE, sep=",",
            row.names=FALSE,col.names = FALSE, na="", append=TRUE)

############################################################################################################

D835Youtputmatrix<-matrix(data=c(SecondMotifsFINAL,names(SecondMotifsFINAL)),ncol = 2)

write.table(x=D835Youtputmatrix,
            file=Second_unshared_motifs_table,
            quote=FALSE, sep=",",
            row.names=FALSE,col.names = FALSE, na="", append=TRUE)

columnalheader<-c(as.character(Firstsubbackfreq[1:36,1]))
columnalheader<-matrix(columnalheader,nrow = 1)
write.table(x=columnalheader,
            file=Second_unshared_subbackfreq,
            quote=FALSE, sep=",",
            row.names=FALSE,col.names = FALSE, na="", append=TRUE)
SecondFinalMatrix<-SecondFinalMatrix[2:nrow(SecondFinalMatrix),]  
write.table(x=SecondFinalMatrix,
            file=Second_unshared_subbackfreq,
            quote=FALSE, sep=",",
            row.names=FALSE,col.names = FALSE, na="", append=TRUE)

############################################################################################################

# ITDoutputmatrix<-matrix(data = c(ITDmotifsFINAL,names(ITDmotifsFINAL)),ncol = 2)
# 
# write.table(x=ITDoutputmatrix,
#             file=Third_unshared_motifs_table,
#             quote=FALSE, sep=",",
#             row.names=FALSE,col.names = FALSE, na="", append=TRUE)
# 
# columnalheader<-c(as.character(Thirdsubbackfreq[1:36,1]))
# columnalheader<-matrix(columnalheader,nrow = 1)
# write.table(x=columnalheader,
#             file=Third_unshared_subbackfreq,
#             quote=FALSE, sep=",",
#             row.names=FALSE,col.names = FALSE, na="", append=TRUE)
# ITDFinalMatrix<-ITDFinalMatrix[2:nrow(ITDFinalMatrix),]
# write.table(x=ITDFinalMatrix,
#             file=Third_unshared_subbackfreq,
#             quote=FALSE, sep=",",
#             row.names=FALSE,col.names = FALSE, na="", append=TRUE)